<?php
class ControladorCobros{

	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function ctrMostrarCobros($item, $valor){

		$tabla = "cobros";

		$respuesta = ModeloCobros::mdlMostrarCobros($tabla, $item, $valor);

		return $respuesta;

	}

	/*=============================================
	MOSTRAR COBROS OPTIMIZADO (para vista de lista con JOIN)
	=============================================*/

	static public function ctrMostrarCobrosOptimizado($item, $valor){

		$tabla = "cobros";

		$respuesta = ModeloCobros::mdlMostrarCobrosOptimizado($tabla, $item, $valor);

		return $respuesta;

	}

	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function ctrMostrarCobrosSerieA($item, $valor){

		$tabla = "cobros";

		$respuesta = ModeloCobros::mdlMostrarCobrosSerieA($tabla, $item, $valor);

		return $respuesta;

	}


	static public function ctrMostrarCronograma($item, $valor){

		$tabla = "detalle_servicio";

		$respuesta = ModeloCobros::mdlMostrarCronograma($tabla, $item, $valor);


		return $respuesta;

	}

	static public function ctrMostrarCobrosReporte($item, $valor){

		$tabla = "editar_cobro";

		$respuesta = ModeloCobros::mdlMostrarCobrosReporte($tabla, $item, $valor);

		return $respuesta;

	}

	static public function ctrMostrarCronogramaPago($item, $valor){

		$tabla = "detalle_servicio";

		$respuesta = ModeloCobros::mdlMostrarCronogramaPago($tabla, $item, $valor);


		return $respuesta;

	}


	static public function ctrEliminarCobro($valor){

		$tabla0 = "cronograma_pago";
		$tabla1 = "cobros";
		$tabla2 = "detalle_cobros";

		$respuesta4 = "";

		$respuesta = ModeloCobros::mdlObtenercronograma($tabla2,$valor);

		if ($respuesta != null){
			foreach ($respuesta as $value) {
				$respuesta2 = ModeloCobros::mdlActualizarCrono($tabla0,$value["idcronograma_pago"]);
			}
			$respuesta3 = ModeloCobros::mdlEliminarCobros($tabla2, $valor);
			if($respuesta3 == "ok"){
				$respuesta4 = ModeloCobros::mdlEliminarCobros($tabla1, $valor);
			}


		}


		return $respuesta4;

	}

	static public function ctrEditarCobro($item,$valor){

		$tabla = "editar_cobro";

		$respuesta = ModeloCobros::mdlEditarCobro($tabla,$item, $valor);


		return $respuesta;

	}

	static public function ctrUltimoPago($valor){

		$tabla = "cronograma_pago";

		$respuesta = ModeloCobros::mdlUltimoPago($tabla,$valor);


		return $respuesta;

	}

	static public function ctrMesesFlatantes($valor){

		$respuesta = ModeloCobros::mdlMesesFlatantes($valor);


		return $respuesta;

	}


	/* Este codigo es para mostrar todo desde vista de la base de datos */

	static public function ctrMostrarContratosCompleta($item, $valor){

		$tabla = "servicios_completo";

		$respuesta = ModeloContratos::mdlMostrarContratosCompleta($tabla, $item, $valor);

		return $respuesta;

	}


	/*=============================================
	CREAR CONTRATOS
	=============================================*/

	static public function ctrGuardarPagos($cadena){
		//$data = json_decode($cadena);

		// Validar que $cadena sea un array válido
		if(!is_array($cadena) || empty($cadena) || !isset($cadena[0]) || !is_array($cadena[0])){
			return "error";
		}

		$res2 = "";
		$res3 = "";
		$res4 = "";
		$tabla = "cobros";
		/*
		1°  idcronograma_pago(0), servicio(1), conceptoPago(2), mes(3), subtotal(4), subtotal(5), X(6), recargo(7), descripcion(8), idservicio(9).
		luego con la funcion append recorro nuevamente el array y agrego nuevos campos que son:
		2°  idpersona(10), idusuario(20), idservicio(12), fecha(13), idcronograma_pago(14), totalMonto(15), CodigoA(16), CodigoR(17), codigoContrato(18), idCaja(19) 
		*/


		// Validar y sanitizar datos antes de crear el array
		$codigoA = isset($cadena[0][16]) && $cadena[0][16] !== '' ? $cadena[0][16] : null;
		$codigoR = isset($cadena[0][17]) && $cadena[0][17] !== '' ? $cadena[0][17] : '';
		$subtotal = isset($cadena[0][15]) && $cadena[0][15] !== '' ? floatval(str_replace(',', '', $cadena[0][15])) : 0;
		$total = $subtotal;
		$recargo = isset($cadena[0][7]) && $cadena[0][7] !== '' ? intval($cadena[0][7]) : 0;
		
		$datos = array(
			"codigo" => isset($cadena[0][1]) && $cadena[0][1] !== '' ? $cadena[0][1] : null,
			"codigoA" => $codigoA,
			"codigoR" => $codigoR,
			"mpago" => isset($cadena[0][21]) ? $cadena[0][21] : '',
			"notitas" => isset($cadena[0][22]) ? $cadena[0][22] : '',
			"banco" => isset($cadena[0][23]) ? $cadena[0][23] : '',
			"idusuario" => isset($cadena[0][11]) && $cadena[0][11] !== '' ? intval($cadena[0][11]) : 0,
			"idpersona" => isset($cadena[0][10]) && $cadena[0][10] !== '' ? intval($cadena[0][10]) : 0,
			"idservicios" => isset($cadena[0][12]) && $cadena[0][12] !== '' ? intval($cadena[0][12]) : 0,
			"subtotal" => $subtotal,
			"total" => $total,
			"fechacobro" => isset($cadena[0][13]) && $cadena[0][13] !== '' ? $cadena[0][13] : date('Y-m-d H:i:s'),
			"recargo" => $recargo,
			"tipo" => isset($cadena[0][20]) ? $cadena[0][20] : 'Todo'
		);

		$respuesta = ModeloCobros::mdlIngresarCobros($tabla, $datos);
		$totalComercial = 0;
		$totalDomiciliario = 0;
		$arrayDescripcion = array();
		$arrayIdServicio = array();
		if($respuesta != "error"){

			foreach ($cadena as $key => $value) {
				if(isset($value[0]) && $value[0] != null && $value[0] !== ''){
					$descripcion = isset($cadena[$key][8]) ? $cadena[$key][8] : '';

					if(!in_array($descripcion, $arrayDescripcion)){
						//echo "<script>alert('".$descripcion."')</script>";
						array_push($arrayDescripcion, $descripcion);
					}
					//$subTotal = number_format(substr($cadena[$key][4], 2),2,'.','');
					$subTotalStr = isset($cadena[$key][4]) ? str_replace(',','', $cadena[$key][4]) : '0';
					$subTotal = floatval($subTotalStr);

					if($descripcion == "Domiciliar"){
						$totalDomiciliario += $subTotal;
					}
					else if ($descripcion == "Comercio"){
						$totalComercial += $subTotal;
					}

					/* if para agregar id de servicio en un array sin que se repitan
					para porteriormente recorrerlo y realizar una consulta que consiste en saber si el servicio contiene mas pagos.
					*/
					$idServicio = isset($cadena[$key][9]) ? $cadena[$key][9] : (isset($value[12]) ? $value[12] : null);
					if($idServicio !== null && !in_array($idServicio, $arrayIdServicio)){
						//echo "<script>alert('".$idServicio."')</script>";
						array_push($arrayIdServicio, $idServicio);
					}

					$ntabla = "detalle_cobros";

					$datos2 = array("idcobro"=>$respuesta,"idcronograma_pago"=>$value[0]);

					$res = ModeloCobros::mdlIngresarDetalleCobros($ntabla, $datos2);

					if($res == "ok"){
						$ntabla1 = "cronograma_pago";
						$ntabla2 = "servicios";
						$res2 = ModeloCobros::mdlActualizarCronograma($ntabla1, $value[0]);

						$recargo = isset($cadena[0][7]) ? intval($cadena[0][7]) : 0;
						$idServicioUpdate = isset($value[12]) ? $value[12] : (isset($value[9]) ? $value[9] : null);
						
						if($idServicioUpdate !== null){
							if($recargo == 1){
								$res3 = ModeloCobros::mdlActualizarServicioR($ntabla2, $idServicioUpdate);
							}else{
								$res3 = ModeloCobros::mdlActualizarServicio($ntabla2, $idServicioUpdate);
							}
						} else {
							$res3 = "ok"; // Si no hay idServicio, consideramos ok para continuar
						}



					}

				}

			}

			/* Datos que necesito para guardar el detalle de la caja ********
		id, idCaja, fecha, tipoCaja(cobranza), concepto(comercial, domiciliaria), numeroDocumento(código del contrato), importeCaja(valor pagado), tipoPago(efectivo), generadoPor(nombre del usuario activo), estado caja (pagado)*/
		if(is_array($arrayDescripcion) && !empty($arrayDescripcion)){
			foreach($arrayDescripcion as $datosDetalle){
				if($datosDetalle == "Comercio"){
					$datos = array(
						"idCaja"=>isset($cadena[0][19]) && $cadena[0][19] !== '' ? intval($cadena[0][19]) : 0,
						"fechacobro"=>isset($cadena[0][13]) && $cadena[0][13] !== '' ? $cadena[0][13] : date('Y-m-d H:i:s'),
						"tipoCaja"=>isset($cadena[0][8]) ? $cadena[0][8] : 'Cobranza',
						"concepto"=>isset($cadena[0][2]) ? $cadena[0][2] : 'Comercio',
						"numeroDocumento"=>isset($cadena[0][16]) && $cadena[0][16] !== '' ? $cadena[0][16] : '',
						"total"=>$totalComercial,
						"tipoPago"=>isset($cadena[0][21]) ? $cadena[0][21] : 'Efectivo',
						"idusuario"=>isset($cadena[0][11]) && $cadena[0][11] !== '' ? $cadena[0][11] : 0,
						"estadoCaja"=>"Pagado"
					);
					$res4 = ModeloCobros::mdlIngresarDetalleCaja("detallecaja", $datos);
				}
				else if($datosDetalle == "Domiciliar"){
					$datos = array(
						"idCaja"=>isset($cadena[0][19]) && $cadena[0][19] !== '' ? intval($cadena[0][19]) : 0,
						"fechacobro"=>isset($cadena[0][13]) && $cadena[0][13] !== '' ? $cadena[0][13] : date('Y-m-d H:i:s'),
						"tipoCaja"=>isset($cadena[0][8]) ? $cadena[0][8] : 'Cobranza',
						"concepto"=>isset($cadena[0][2]) ? $cadena[0][2] : 'Domiciliar',
						"numeroDocumento"=>isset($cadena[0][16]) && $cadena[0][16] !== '' ? $cadena[0][16] : '',
						"total"=>$totalDomiciliario,
						"tipoPago"=>isset($cadena[0][21]) ? $cadena[0][21] : 'Efectivo',
						"idusuario"=>isset($cadena[0][11]) && $cadena[0][11] !== '' ? $cadena[0][11] : 0,
						"estadoCaja"=>"Pagado"
					);
					$res4 = ModeloCobros::mdlIngresarDetalleCaja("detallecaja", $datos);
				}

			}
		}

		if(is_array($arrayIdServicio) && !empty($arrayIdServicio)){
			foreach($arrayIdServicio as $idServicio_){
				$estado = ModeloCobros::mdlObtenerCobrosFaltantes($idServicio_);

				if($estado != null){
					if ($estado["conteo"] == 0) {
						$estado2 = ModeloCobros::mdlFinalizarServicio($idServicio_);
					}
				}
			}

		}


		}

		if($res2 == "ok" && $res3 == "ok" && ($res4 == "ok" || $res4 == "")){
			return "ok";
		} else {
			return "error";
		}



	}


	/*=============================================
	RANGO FECHAS
	=============================================*/

	static public function ctrRangoFechasContratos($fechaInicial, $fechaFinal){

		$tabla = "servicios";

		$respuesta = ModeloContratos::mdlFechasContratos($tabla, $fechaInicial, $fechaFinal);

		return $respuesta;

	}



	/*=============================================
	EDITAR CONTRATOS
	=============================================*/

	static public function ctrEditarContratos(){

		if(isset($_POST["nuevoNombreCliente"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombreCliente"]) &&
			   preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoTipoServicio"])){

			   	$tabla = "servicios";

			   	$datos = array("idservicios"=>$_POST["idservicios"],
			   				   "codigo"=>$_POST["nuevoCodigo"],
					           "idusuario"=>$_POST["IdUsuario"],
					           "idpersona"=>$_POST["idpersona"],
					           "numromeses"=>$_POST["nuevoMeses"],
					           "idtipo_servicios"=>$_POST["idtipo_servicios"]);

			   	$respuesta = ModeloContratos::mdlEditarContratos($tabla, $datos);

			   	if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El contrato de servicio ha sido actualizado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "personas";

									}
								})

					</script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El contrato de servicio no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "personas";

							}
						})

			  	</script>';



			}

		}

	}


	/*=============================================
	ELIMINAR CONTRATOS
	=============================================*/

	static public function ctrEliminarContrato(){

		if(isset($_GET["idservicios"])){

			$tabla ="servicios";
			$datos = $_GET["idservicios"];

			$respuesta = ModeloContratos::mdlEliminarContrato($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				swal({
					  type: "success",
					  title: "El cliente ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result){
								if (result.value) {

								window.location = "personas";

								}
							})

				</script>';

			}

		}

	}







}
